<?php
// Authentication and authorization helpers

require_once __DIR__ . '/../config/db.php';

function require_login() {
    if (empty($_SESSION['admin_id'])) {
        header('Location: ' . BASE_URL . 'login.php');
        exit;
    }
}

function current_user() {
    return isset($_SESSION['admin_user']) ? $_SESSION['admin_user'] : null;
}

function has_role($roles) {
    $user = current_user();
    if (!$user) return false;

    if (!is_array($roles)) {
        $roles = [$roles];
    }

    // Superadmin can do everything
    if ($user['role'] === 'superadmin') {
        return true;
    }

    return in_array($user['role'], $roles, true);
}

function can_host_events() {
    $user = current_user();
    if (!$user) return false;

    if ($user['role'] === 'superadmin') {
        return true;
    }

    return !empty($user['can_host_events']);
}

function require_role($roles) {
    if (!has_role($roles)) {
        http_response_code(403);
        echo "Forbidden – you don't have permission to access this.";
        exit;
    }
}
