<?php
require_once __DIR__ . '/../includes/header.php';

if (!can_host_events()) {
    http_response_code(403);
    echo 'Forbidden – you are not allowed to create or host events. Please contact the super admin.';
    require_once __DIR__ . '/../includes/footer.php';
    exit;
}

$id = $_GET['id'] ?? null;
$event = null;
$client = null;
$isEdit = false;

if ($id) {
    $stmt = $pdo->prepare('
      SELECT e.*, c.name AS client_name, c.email AS client_email, c.phone AS client_phone
      FROM events e
      JOIN clients c ON e.client_id = c.id
      WHERE e.id = :id
      LIMIT 1
    ');
    $stmt->execute(['id' => $id]);
    $event = $stmt->fetch();
    if (!$event) {
        echo 'Event not found.';
        require_once __DIR__ . '/../includes/footer.php';
        exit;
    }
    $isEdit = true;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $client_name  = trim($_POST['client_name'] ?? '');
    $client_email = trim($_POST['client_email'] ?? '');
    $client_phone = trim($_POST['client_phone'] ?? '');
    $title        = trim($_POST['title'] ?? '');
    $event_date   = $_POST['event_date'] ?? null;
    $location     = trim($_POST['location'] ?? '');
    $status       = $_POST['status'] ?? 'pending';
    $upload_url   = trim($_POST['upload_url'] ?? '');

    if ($client_name && $title) {
        // Find or create client by email (if provided) or name
        if ($client_email) {
            $cStmt = $pdo->prepare('SELECT * FROM clients WHERE email = :email LIMIT 1');
            $cStmt->execute(['email' => $client_email]);
            $client = $cStmt->fetch();
        } else {
            $client = null;
        }

        if (!$client) {
            $insertClient = $pdo->prepare('
              INSERT INTO clients (name, email, phone)
              VALUES (:name, :email, :phone)
            ');
            $insertClient->execute([
                'name'  => $client_name,
                'email' => $client_email ?: null,
                'phone' => $client_phone ?: null,
            ]);
            $client_id = $pdo->lastInsertId();
        } else {
            $client_id = $client['id'];
            // Update client basic info
            $updateClient = $pdo->prepare('
              UPDATE clients SET name=:name, phone=:phone WHERE id=:id
            ');
            $updateClient->execute([
                'name'  => $client_name,
                'phone' => $client_phone ?: null,
                'id'    => $client_id,
            ]);
        }

        if ($isEdit) {
            $stmt = $pdo->prepare('
              UPDATE events
              SET client_id=:client_id, title=:title, event_date=:event_date,
                  location=:location, status=:status, upload_url=:upload_url
              WHERE id=:id
            ');
            $stmt->execute([
                'client_id'  => $client_id,
                'title'      => $title,
                'event_date' => $event_date ?: null,
                'location'   => $location,
                'status'     => $status,
                'upload_url' => $upload_url ?: null,
                'id'         => $id,
            ]);
        } else {
            $stmt = $pdo->prepare('
              INSERT INTO events (client_id, title, event_date, location, status, upload_url)
              VALUES (:client_id, :title, :event_date, :location, :status, :upload_url)
            ');
            $stmt->execute([
                'client_id'  => $client_id,
                'title'      => $title,
                'event_date' => $event_date ?: null,
                'location'   => $location,
                'status'     => $status,
                'upload_url' => $upload_url ?: null,
            ]);
        }

        header('Location: events.php');
        exit;
    } else {
        $error = 'Client name and event title are required.';
    }
}

$client_name  = $event['client_name']  ?? '';
$client_email = $event['client_email'] ?? '';
$client_phone = $event['client_phone'] ?? '';
$title        = $event['title']        ?? '';
$event_date   = $event['event_date']   ?? '';
$location     = $event['location']     ?? '';
$status       = $event['status']       ?? 'pending';
$upload_url   = $event['upload_url']   ?? '';
?>
<div class="page-header">
  <div>
    <h1><?php echo $isEdit ? 'Edit Event' : 'New Event'; ?></h1>
  </div>
</div>

<div class="card">
  <?php if (!empty($error)): ?>
    <div class="alert-error"><?php echo htmlspecialchars($error); ?></div>
  <?php endif; ?>

  <form method="post" class="form">
    <h3>Client Details</h3>
    <label>Client Name
      <input type="text" name="client_name" value="<?php echo htmlspecialchars($client_name); ?>" required>
    </label>
    <label>Client Email
      <input type="email" name="client_email" value="<?php echo htmlspecialchars($client_email); ?>">
    </label>
    <label>Client Phone
      <input type="text" name="client_phone" value="<?php echo htmlspecialchars($client_phone); ?>">
    </label>

    <h3>Event Details</h3>
    <label>Event Title
      <input type="text" name="title" value="<?php echo htmlspecialchars($title); ?>" required>
    </label>
    <label>Event Date
      <input type="date" name="event_date" value="<?php echo htmlspecialchars($event_date); ?>">
    </label>
    <label>Location
      <input type="text" name="location" value="<?php echo htmlspecialchars($location); ?>">
    </label>
    <label>Status
      <select name="status">
        <?php
        $statuses = ['pending','active','completed','archived'];
        foreach ($statuses as $s):
        ?>
          <option value="<?php echo $s; ?>" <?php echo $s === $status ? 'selected' : ''; ?>>
            <?php echo ucfirst($s); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </label>
    <label>Upload URL (guest upload page)
      <input type="text" name="upload_url" value="<?php echo htmlspecialchars($upload_url); ?>">
    </label>

    <button type="submit" class="btn">Save Event</button>
  </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
