<?php
require_once __DIR__ . '/../includes/header.php';

$events = $pdo->query('
  SELECT e.*, c.name AS client_name 
  FROM events e
  JOIN clients c ON e.client_id = c.id
  ORDER BY e.created_at DESC
')->fetchAll();
?>
<div class="page-header">
  <div>
    <h1>Events</h1>
    <div class="page-header-subtitle">All ClipnPic-hosted events and upload portals.</div>
  </div>
  <div>
    <?php if (can_host_events()): ?>
      <a href="event-edit.php" class="btn">+ New Event</a>
    <?php endif; ?>
  </div>
</div>

<div class="card">
  <table class="table">
    <thead>
      <tr>
        <th>ID</th><th>Title</th><th>Client</th><th>Date</th><th>Status</th><th>Upload Link</th><th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($events as $e): ?>
        <tr>
          <td><?php echo $e['id']; ?></td>
          <td><?php echo htmlspecialchars($e['title']); ?></td>
          <td><?php echo htmlspecialchars($e['client_name']); ?></td>
          <td><?php echo $e['event_date']; ?></td>
          <td><?php echo $e['status']; ?></td>
          <td>
            <?php if ($e['upload_url']): ?>
              <a href="<?php echo htmlspecialchars($e['upload_url']); ?>" target="_blank">Open</a>
            <?php else: ?>
              —
            <?php endif; ?>
          </td>
          <td><a href="event-edit.php?id=<?php echo $e['id']; ?>">Edit</a></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
