<?php
require_once __DIR__ . '/../includes/header.php';
require_role(['superadmin','accountant']);

$invoices = $pdo->query('
  SELECT i.*, e.title AS event_title
  FROM invoices i
  JOIN events e ON i.event_id = e.id
  ORDER BY i.created_at DESC
')->fetchAll();
?>
<div class="page-header">
  <div>
    <h1>Invoices</h1>
    <div class="page-header-subtitle">High-level view of event invoices (read-only stub).</div>
  </div>
</div>

<div class="card">
  <table class="table">
    <thead>
      <tr>
        <th>ID</th><th>Event</th><th>Amount</th><th>Status</th><th>Due</th><th>Paid At</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($invoices as $inv): ?>
        <tr>
          <td><?php echo $inv['id']; ?></td>
          <td><?php echo htmlspecialchars($inv['event_title']); ?></td>
          <td>$<?php echo number_format($inv['amount'], 2); ?></td>
          <td><?php echo $inv['status']; ?></td>
          <td><?php echo $inv['due_date']; ?></td>
          <td><?php echo $inv['paid_at']; ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
