<?php
require_once __DIR__ . '/../config/db.php';

if (!empty($_SESSION['admin_id'])) {
    header('Location: ' . BASE_URL . 'index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($email && $password) {
        $stmt = $pdo->prepare('SELECT * FROM admin_users WHERE email = :email AND is_active = 1 LIMIT 1');
        $stmt->execute(['email' => $email]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['admin_id']   = $user['id'];
            $_SESSION['admin_user'] = [
                'id'              => $user['id'],
                'name'            => $user['name'],
                'email'           => $user['email'],
                'role'            => $user['role'],
                'can_host_events' => (int)$user['can_host_events'],
            ];
            header('Location: ' . BASE_URL . 'index.php');
            exit;
        } else {
            $error = 'Invalid email or password.';
        }
    } else {
        $error = 'Please fill in both fields.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>ClipnPic Admin – Login</title>
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>assets/css/admin.css">
</head>
<body class="login-page">
  <div class="login-container">
    <h1>Welcome back</h1>
    <p>Sign in to access the ClipnPic admin dashboard.</p>
    <?php if ($error): ?>
      <div class="alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <form method="post" class="form">
      <label>Email
        <input type="email" name="email" required>
      </label>
      <label>Password
        <input type="password" name="password" required>
      </label>
      <button type="submit" class="btn" style="width:100%; margin-top:0.5rem;">Log In</button>
    </form>
  </div>
</body>
</html>
