<?php
require_once __DIR__ . '/../includes/header.php';

$user = current_user();

// Handle send new message (team to team)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['receiver_id'])) {
    $receiver_id = (int) ($_POST['receiver_id'] ?? 0);
    $subject     = trim($_POST['subject'] ?? '');
    $body        = trim($_POST['body'] ?? '');

    if ($receiver_id && $body) {
        $insert = $pdo->prepare('
          INSERT INTO messages 
          (sender_type, sender_id, receiver_type, receiver_id, subject, body) 
          VALUES ("admin", :sid, "admin", :rid, :subject, :body)
        ');
        $insert->execute([
            'sid'     => $user['id'],
            'rid'     => $receiver_id,
            'subject' => $subject ?: null,
            'body'    => $body,
        ]);
        header('Location: messages.php');
        exit;
    }
}

// Fetch messages where this admin is the receiver
$stmt = $pdo->prepare('
  SELECT m.*, 
         CASE 
           WHEN m.sender_type = "admin" THEN au.name
           ELSE c.name 
         END AS sender_name
  FROM messages m
  LEFT JOIN admin_users au ON (m.sender_type = "admin" AND m.sender_id = au.id)
  LEFT JOIN clients c ON (m.sender_type = "client" AND m.sender_id = c.id)
  WHERE m.receiver_type = "admin" AND m.receiver_id = :id
  ORDER BY m.created_at DESC
');
$stmt->execute(['id' => $user['id']]);
$messages = $stmt->fetchAll();

$admins = $pdo->query('SELECT id, name FROM admin_users WHERE is_active = 1 ORDER BY name')->fetchAll();
?>
<div class="page-header">
  <div>
    <h1>Messages</h1>
    <div class="page-header-subtitle">Internal team messages and client conversations.</div>
  </div>
</div>

<div class="grid-2">
  <div class="card">
    <h3>Send New Message (Team)</h3>
    <form method="post" class="form">
      <label>To
        <select name="receiver_id" required>
          <option value="">-- Select admin --</option>
          <?php foreach ($admins as $a): if ($a['id'] == $user['id']) continue; ?>
            <option value="<?php echo $a['id']; ?>"><?php echo htmlspecialchars($a['name']); ?></option>
          <?php endforeach; ?>
        </select>
      </label>
      <label>Subject
        <input type="text" name="subject">
      </label>
      <label>Message
        <textarea name="body" rows="4" required></textarea>
      </label>
      <button type="submit" class="btn">Send</button>
    </form>
  </div>

  <div class="card">
    <h3>Your Inbox</h3>
    <table class="table">
      <thead>
        <tr>
          <th>From</th><th>Subject</th><th>Preview</th><th>Date</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($messages as $m): ?>
          <tr>
            <td><?php echo htmlspecialchars($m['sender_name'] ?? 'Unknown'); ?></td>
            <td><?php echo htmlspecialchars($m['subject'] ?? '(no subject)'); ?></td>
            <td><?php echo htmlspecialchars(mb_substr($m['body'], 0, 60)); ?>...</td>
            <td><?php echo $m['created_at']; ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
