<?php
require_once __DIR__ . '/../includes/header.php';
require_role('superadmin');

// Handle save
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST['settings'] as $key => $value) {
        $key = trim($key);
        $value = trim($value);
        if ($key === '') continue;

        $stmt = $pdo->prepare('
          INSERT INTO settings (setting_key, setting_value)
          VALUES (:k, :v)
          ON DUPLICATE KEY UPDATE setting_value = :v2
        ');
        $stmt->execute([
            'k'  => $key,
            'v'  => $value,
            'v2' => $value,
        ]);
    }
}

// Load all settings
$settings = [];
$result = $pdo->query('SELECT setting_key, setting_value FROM settings ORDER BY setting_key ASC');
foreach ($result as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>
<div class="page-header">
  <div>
    <h1>Settings</h1>
    <div class="page-header-subtitle">Global configuration for ClipnPic admin.</div>
  </div>
</div>

<div class="card">
  <form method="post" class="form">
    <label>Public Upload Base URL
      <input type="text" name="settings[public_upload_base]" value="<?php echo htmlspecialchars($settings['public_upload_base'] ?? ''); ?>">
    </label>
    <label>Support Email
      <input type="email" name="settings[support_email]" value="<?php echo htmlspecialchars($settings['support_email'] ?? ''); ?>">
    </label>
    <button type="submit" class="btn">Save Settings</button>
  </form>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
